<?php
/**
 * @package     Joomla.Site
 * @subpackage  Layout
 * @copyright   Copyright ( C ) Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

use Joomla\CMS\HTML\HTMLHelper;

extract($displayData);
/**
 * Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern ( Reg Ex ) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellchec       Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   array    $checkedOptions  Options that will be set as checked.
 * @var   boolean  $hasValue        Has this field a value assigned?
 * @var   array    $options         Options available for this field.
 * @var   array    $checked         Is this field checked?
 * @var   array    $position        Is this field checked?
 * @var   array    $control         Is this field checked?
 */

$class = ' class="uk-select ' . trim('simplecolors chzn-done ' . $class) . '"';
$disabled = $disabled ? ' disabled' : '';
$readonly = $readonly ? ' readonly' : '';

// Include jQuery
HTMLHelper::_('jquery.framework');
HTMLHelper::_('script', 'system/html5fallback.js', ['version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9']);
HTMLHelper::_('script', 'jui/jquery.simplecolors.min.js', ['version' => 'auto', 'relative' => true]);
HTMLHelper::_('stylesheet', 'jui/jquery.simplecolors.css', ['version' => 'auto', 'relative' => true]);
HTMLHelper::_('script', 'system/color-field-init.min.js', ['version' => 'auto', 'relative' => true]);
?>
<select
    name="<?php echo $name; ?>"
    id="<?php echo $id; ?>"
    <?php echo $disabled; ?>
    <?php echo $readonly; ?>
    <?php echo $required; ?>
    <?php echo $class; ?>
    <?php echo $position; ?>
    <?php echo $onchange; ?>
    <?php echo $autofocus; ?>
    style="visibility:hidden;width:22px;height:1px"
>
    <?php foreach ($colors as $i => $c) { ?>
        <option<?php echo ($c == $color ? ' selected="selected"' : ''); ?>><?php echo $c; ?></option>
        <?php if (($i + 1) % $split == 0) { ?>
            <option>-</option>
        <?php } ?>
    <?php } ?>
</select>
